<?php
// payment/chanel_payment.php
// POST -> registered_apps = "com.dokterac.com"
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { exit; }
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  http_response_code(405);
  echo json_encode(['success'=>false,'message'=>'Method Not Allowed']); exit;
}

require '../connection.php';
$connect->set_charset('utf8mb4');

// --- ambil input dari JSON body atau x-www-form-urlencoded ---
$raw = file_get_contents('php://input');
$ctype = isset($_SERVER['CONTENT_TYPE']) ? strtolower($_SERVER['CONTENT_TYPE']) : '';

$registered_apps = '';
if (strpos($ctype, 'application/json') !== false && $raw) {
  $j = json_decode($raw, true);
  if (is_array($j) && isset($j['registered_apps'])) {
    $registered_apps = trim($j['registered_apps']);
  }
}
if ($registered_apps === '' && isset($_POST['registered_apps'])) {
  $registered_apps = trim($_POST['registered_apps']);
}

if ($registered_apps === '' || strlen($registered_apps) > 100) {
  http_response_code(400);
  echo json_encode(['success'=>false,'message'=>'registered_apps wajib diisi']); exit;
}
// optional whitelist sederhana
if (!preg_match('/^[a-z0-9._-]+(\.[a-z0-9._-]+)*$/i', $registered_apps)) {
  http_response_code(400);
  echo json_encode(['success'=>false,'message'=>'registered_apps tidak valid']); exit;
}

$sql = "
  SELECT code, label, subtitle, service_fee, sort_order
  FROM chanel_payment
  WHERE registered_apps = ? AND is_active = 1
  ORDER BY sort_order ASC, id ASC
";
$stmt = $connect->prepare($sql);
$stmt->bind_param('s', $registered_apps);
$stmt->execute();
$res = $stmt->get_result();

$data = [];
while ($row = $res->fetch_assoc()) {
  $data[] = [
    'code'        => $row['code'],
    'label'       => $row['label'],
    'subtitle'    => $row['subtitle'],
    'service_fee' => (int)$row['service_fee'],
  ];
}
$stmt->close();
$connect->close();

echo json_encode([
  'success'         => true,
  'registered_apps' => $registered_apps,
  'count'           => count($data),
  'data'            => $data,
], JSON_UNESCAPED_UNICODE);
