<?php
// payment/charge.php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

require '../connection.php';
$connect->set_charset('utf8mb4');

// ===== MIDTRANS CONFIG =====
// $isProduction = false; // true kalau sudah live
// $serverKey    = 'SB-Mid-server-pAi950ZMKHjxgGA1SWmPOh2I';
$isProduction = true; // true kalau sudah live
$serverKey    = 'Mid-server-5uX1XVBoRH6ds2i7pQcmOzsr';


$baseUrl      = $isProduction
  ? 'https://api.midtrans.com/v2'
  : 'https://api.sandbox.midtrans.com/v2';

// ===== INPUT =====
$raw  = file_get_contents('php://input');
$body = json_decode($raw, true);
if (!is_array($body)) $body = $_POST;

$transaction_id = isset($body['transaction_id']) ? (int)$body['transaction_id'] : 0;
$gross_amount   = isset($body['gross_amount']) ? (int)$body['gross_amount'] : 0;
$customer       = $body['customer'] ?? [];
$method         = isset($body['method']) ? trim($body['method']) : '';
$items          = (isset($body['items']) && is_array($body['items'])) ? $body['items'] : [];
$kode_apk       = isset($body['kode_apk']) ? substr(trim($body['kode_apk']),0,10) : 'DP';

if ($transaction_id <= 0 || $gross_amount <= 0 || $method === '') {
  echo json_encode(['success'=>false, 'error'=>'invalid_params']); exit;
}

// Ambil user_id dari tb_transactions
$user_id = null;
$stmtU = $connect->prepare("SELECT user_id FROM tb_transactions WHERE transaction_id = ?");
$stmtU->bind_param('i', $transaction_id);
$stmtU->execute();
$stmtU->bind_result($user_id);
$stmtU->fetch();
$stmtU->close();
if (!$user_id) $user_id = 0;

// order_id untuk Midtrans
$order_id = 'DP-' . $transaction_id;

// bangun payload
list($type, $bank) = array_pad(explode(':', $method, 2), 2, null);
$payload = [
  'payment_type' => $type,
  'transaction_details' => [
    'order_id'     => $order_id,
    'gross_amount' => $gross_amount,
  ],
  'item_details' => $items,
  'customer_details' => [
    'first_name' => (string)($customer['name']  ?? ''),
    'email'      => (string)($customer['email'] ?? ''),
    'phone'      => (string)($customer['phone'] ?? ''),
  ],
];

if ($type === 'bank_transfer') {
  $payload['bank_transfer'] = ['bank' => strtolower($bank ?? 'bni')];
} elseif ($type === 'gopay') {
  $payload['gopay'] = new stdClass();
} elseif ($type === 'qris') {
  $payload['qris'] = new stdClass();
}

// call midtrans
$ch = curl_init("$baseUrl/charge");
curl_setopt_array($ch, [
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_POST           => true,
  CURLOPT_HTTPHEADER     => [
    'Content-Type: application/json',
    'Accept: application/json',
    'Authorization: Basic ' . base64_encode($serverKey . ':'),
  ],
  CURLOPT_POSTFIELDS     => json_encode($payload),
]);
$res  = curl_exec($ch);
$http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$err  = curl_error($ch);
curl_close($ch);

if ($res === false || $http >= 400) {
  echo json_encode(['success'=>false,'error'=>'midtrans_error','detail'=>$err,'http'=>$http,'res'=>$res]); exit;
}
$mt = json_decode($res, true);
if (!is_array($mt)) {
  echo json_encode(['success'=>false,'error'=>'invalid_midtrans_response']); exit;
}

// ambil field untuk app
$redirect_url = $mt['redirect_url'] ?? null;

// VA
$va_number = null; $va_bank = null;
if (!empty($mt['va_numbers'][0]['va_number'])) {
  $va_number = $mt['va_numbers'][0]['va_number'];
  $va_bank   = strtoupper($mt['va_numbers'][0]['bank'] ?? '');
} elseif (!empty($mt['permata_va_number'])) {
  $va_number = $mt['permata_va_number'];
  $va_bank   = 'PERMATA';
}

// QR (beberapa channel “actions[0].url” / “qr_code”)
$qr_url = $mt['actions'][0]['url'] ?? ($mt['qr_code'] ?? null);

// token_pembayaran yang disimpan
$tokenPembayaran = $va_number ?: ($qr_url ?: ($redirect_url ?: ($mt['token'] ?? '')));

// simpan ke tb_payment_methods
$status  = 'pending';
$typeCol = $method;
$details = json_encode([
  'order_id'     => $order_id,
  'midtrans_raw' => $mt,
], JSON_UNESCAPED_UNICODE);

$sql = "INSERT INTO tb_payment_methods
        (kode_apk, user_id, transaction_id, type, status, token_pembayaran, details)
        VALUES (?, ?, ?, ?, ?, ?, ?)";
$stmt = $connect->prepare($sql);
$stmt->bind_param('siissss', $kode_apk, $user_id, $transaction_id, $typeCol, $status, $tokenPembayaran, $details);
$stmt->execute();
$stmt->close();

// response ke app
echo json_encode([
  'success'      => true,
  'order_id'     => $order_id,
  'redirect_url' => $redirect_url,
  'va_number'    => $va_number,
  'bank'         => $va_bank,
  'qr_url'       => $qr_url,
], JSON_UNESCAPED_UNICODE);

$connect->close();
