<?php
// api/payment/config.php
// ================ MIDTRANS CONFIG ================

// $MIDTRANS_SERVER_KEY    = 'SB-Mid-server-pAi950ZMKHjxgGA1SWmPOh2I'; // GANTI server key
// $MIDTRANS_IS_PRODUCTION = false; // true jika live

$MIDTRANS_SERVER_KEY    = 'Mid-server-5uX1XVBoRH6ds2i7pQcmOzsr'; // GANTI server key
$MIDTRANS_IS_PRODUCTION = true; // true jika live


$MIDTRANS_BASE = $MIDTRANS_IS_PRODUCTION
  ? 'https://api.midtrans.com'
  : 'https://api.sandbox.midtrans.com';

// Basic CORS
function cors() {
  header('Content-Type: application/json; charset=utf-8');
  header('Access-Control-Allow-Origin: *');
  header('Access-Control-Allow-Headers: Content-Type, Authorization');
  header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
  if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }
}

// HTTP helper ke Midtrans
function midtrans_request(string $path, $payload = null, string $method = 'POST') {
  global $MIDTRANS_SERVER_KEY, $MIDTRANS_BASE;
  $url = rtrim($MIDTRANS_BASE, '/') . $path;

  $ch = curl_init($url);
  curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_USERPWD        => $MIDTRANS_SERVER_KEY . ':',
    CURLOPT_HTTPHEADER     => ['Content-Type: application/json', 'Accept: application/json'],
    CURLOPT_CUSTOMREQUEST  => $method,
    CURLOPT_TIMEOUT        => 60,
  ]);
  if ($payload !== null) curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));

  $res  = curl_exec($ch);
  $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  $err  = curl_error($ch);
  curl_close($ch);

  return [$code, $res, $err];
}

// Parse order_id "DP-123" -> 123
function parse_txid_from_order(string $order_id): ?int {
  if (preg_match('/^DP-(\d+)$/', $order_id, $m)) return (int)$m[1];
  return null;
}
