<?php
// payment/info.php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

require '../connection.php';
$connect->set_charset('utf8mb4');

// TERIMA HANYA transaction_id (numeric)
$transaction_id = isset($_GET['transaction_id']) ? (int)$_GET['transaction_id'] : 0;
// (opsional fallback kalau client lama kirim order_id numeric)
if ($transaction_id <= 0 && isset($_GET['order_id'])) {
  $oid = trim($_GET['order_id']);
  if (ctype_digit($oid)) $transaction_id = (int)$oid;
}

if ($transaction_id <= 0) {
  echo json_encode(['success'=>false,'error'=>'no_transaction_id']); exit;
}

$stmt = $connect->prepare("
  SELECT payment_id, type, status, token_pembayaran, details
  FROM tb_payment_methods
  WHERE transaction_id=?
  ORDER BY payment_id DESC
  LIMIT 1
");
$stmt->bind_param('i', $transaction_id);
$stmt->execute();
$res  = $stmt->get_result();
$row  = $res->fetch_assoc();
$stmt->close();

if (!$row) {
  echo json_encode(['success'=>false,'error'=>'not_found']); exit;
}

$type   = (string)($row['type'] ?? '');
$status = (string)($row['status'] ?: 'pending');
$token  = (string)($row['token_pembayaran'] ?? '');
$bank   = null;
$va     = null;
$qr     = null;
$redir  = null;

// Mapping utama dari token_pembayaran
if (stripos($type, 'bank_transfer:') === 0) {
  $bank = strtoupper(substr($type, strlen('bank_transfer:'))); // bni | bri | permata | bsi | cimb
  $va   = preg_replace('/\D+/', '', $token);                    // VA dari token
} elseif (strcasecmp($type, 'qris') === 0) {
  $qr   = $token;  // URL QR image
} else {
  $redir = $token; // eWallet/Snap redirect URL
}

// Fallback dari details (jika ada)
$details = [];
if (!empty($row['details'])) {
  $tmp = json_decode($row['details'], true);
  if (is_array($tmp)) $details = $tmp;

  if (!$redir) {
    $redir = $details['redirect_url']
          ?? ($details['midtrans_raw']['redirect_url'] ?? null);
    if (!$redir && !empty($details['actions']) && is_array($details['actions'])) {
      foreach ($details['actions'] as $a) {
        if (!empty($a['url'])) { $redir = $a['url']; break; }
      }
    }
    if (!$redir && !empty($details['midtrans_raw']['actions']) && is_array($details['midtrans_raw']['actions'])) {
      foreach ($details['midtrans_raw']['actions'] as $a) {
        if (!empty($a['url'])) { $redir = $a['url']; break; }
      }
    }
  }

  if (!$va && stripos($type, 'bank_transfer:') === 0) {
    $va = $details['va_number'] ?? ($details['permata_va_number'] ?? null);
    if (!$va && !empty($details['va_numbers'][0]['va_number'])) {
      $va = $details['va_numbers'][0]['va_number'];
      if (!$bank && !empty($details['va_numbers'][0]['bank'])) {
        $bank = strtoupper($details['va_numbers'][0]['bank']);
      }
    }
    if (!$va && !empty($details['midtrans_raw'])) {
      $mr = $details['midtrans_raw'];
      if (!empty($mr['permata_va_number'])) $va = $mr['permata_va_number'];
      if (!$va && !empty($mr['va_numbers'][0]['va_number'])) {
        $va = $mr['va_numbers'][0]['va_number'];
        if (!$bank && !empty($mr['va_numbers'][0]['bank'])) {
          $bank = strtoupper($mr['va_numbers'][0]['bank']);
        }
      }
    }
  }

  if (!$qr && strcasecmp($type, 'qris') === 0) {
    $qr = $details['qr_url'] ?? ($details['midtrans_raw']['qr_url'] ?? null);
  }
}

echo json_encode([
  'success' => true,
  'data'    => [
    'transaction_id'     => $transaction_id,
    'transaction_status' => $status,
    'method'             => $type,
    'bank'               => $bank ?: null,
    'va_number'          => $va ?: null,
    'qr_url'             => $qr ?: null,
    'redirect_url'       => $redir ?: null,
    'details'            => $details,
  ],
], JSON_UNESCAPED_UNICODE);

$connect->close();
