<?php
// payment/status.php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

require '../connection.php';
$connect->set_charset('utf8mb4');

// $isProduction = false;
// $serverKey    = 'SB-Mid-server-pAi950ZMKHjxgGA1SWmPOh2I';
$isProduction = true;
$serverKey    = 'Mid-server-5uX1XVBoRH6ds2i7pQcmOzsr';
$baseUrl      = $isProduction
  ? 'https://api.midtrans.com/v2'
  : 'https://api.sandbox.midtrans.com/v2';

$order_id       = isset($_GET['order_id']) ? trim($_GET['order_id']) : '';
$transaction_id = isset($_GET['transaction_id']) ? (int)$_GET['transaction_id'] : 0;
if ($order_id === '' && $transaction_id > 0) {
  $order_id = 'DP-' . $transaction_id;
}
if ($order_id === '') { echo json_encode(['success'=>false,'error'=>'no_order_id']); exit; }

$ch = curl_init("$baseUrl/$order_id/status");
curl_setopt_array($ch, [
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_HTTPHEADER     => [
    'Accept: application/json',
    'Authorization: Basic ' . base64_encode($serverKey . ':'),
  ],
]);
$res  = curl_exec($ch);
$http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$err  = curl_error($ch);
curl_close($ch);

if ($res === false || $http >= 400) {
  echo json_encode(['success'=>false,'error'=>'midtrans_error','detail'=>$err,'http'=>$http,'res'=>$res]); exit;
}
$mt = json_decode($res, true);
if (!is_array($mt)) { echo json_encode(['success'=>false,'error'=>'invalid_midtrans_response']); exit; }

$trxStatus = $mt['transaction_status'] ?? 'pending';

// ambil trx id numeric dari order_id
if ($transaction_id <= 0 && preg_match('/^DP-(\d+)$/', $order_id, $m)) {
  $transaction_id = (int)$m[1];
}

// update db (payment_methods)
if ($transaction_id > 0) {
  $stmt = $connect->prepare("UPDATE tb_payment_methods SET status=? WHERE transaction_id=?");
  $stmt->bind_param('si', $trxStatus, $transaction_id);
  $stmt->execute();
  $stmt->close();

  // optional: sinkronkan tb_transactions
//   $stmt2 = $connect->prepare("UPDATE tb_transactions SET status=? WHERE transaction_id=?");
//   $stmt2->bind_param('si', $trxStatus, $transaction_id);
//   $stmt2->execute();
//   $stmt2->close();
}

echo json_encode([
  'success'             => true,
  'order_id'            => $order_id,
  'transaction_status'  => $trxStatus,
], JSON_UNESCAPED_UNICODE);

$connect->close();
