<?php
// payment/status_local.php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

require '../connection.php';
$connect->set_charset('utf8mb4');

// TERIMA HANYA transaction_id (numeric)
$transaction_id = isset($_GET['transaction_id']) ? (int)$_GET['transaction_id'] : 0;
// (opsional, jaga-jaga kalau client lama kirim order_id numeric)
if ($transaction_id <= 0 && isset($_GET['order_id'])) {
  $oid = trim($_GET['order_id']);
  if (ctype_digit($oid)) $transaction_id = (int)$oid;
}

if ($transaction_id <= 0) {
  echo json_encode(['success'=>false,'error'=>'no_transaction_id']); exit;
}

$stmt = $connect->prepare("
  SELECT status
  FROM tb_payment_methods
  WHERE transaction_id=?
  ORDER BY payment_id DESC
  LIMIT 1
");
$stmt->bind_param('i', $transaction_id);
$stmt->execute();
$res  = $stmt->get_result();
$row  = $res->fetch_assoc();
$stmt->close();

$status = $row ? ($row['status'] ?: 'pending') : 'pending';

echo json_encode([
  'success'            => true,
  'transaction_id'     => $transaction_id,
  'transaction_status' => $status,
], JSON_UNESCAPED_UNICODE);

$connect->close();
