<?php

include '../connection.php';

$email = $_POST['email'];
$password = $_POST['password'];
$registered_apps = $_POST['registered_apps'] ?? null; // mengambil registered_apps jika diset

// Query SQL dengan parameterisasi untuk keamanan
$sql = "SELECT * FROM tb_users WHERE email = ? AND status = 'activ'";

// Tambahkan filter 'registered_apps' jika diset
if ($registered_apps) {
    $sql .= " AND registered_apps = ?";
}

$stmt = $connect->prepare($sql);

// Bind parameter berdasarkan kondisi
if ($registered_apps) {
    $stmt->bind_param("ss", $email, $registered_apps);
} else {
    $stmt->bind_param("s", $email);
}

// Eksekusi statement dan ambil hasilnya
$stmt->execute();
$result = $stmt->get_result();
$vw = $result->fetch_assoc();

if ($vw && password_verify($password, $vw['password'])) {
    echo json_encode(array(
        "success" => true,
        "data" => $vw,
    ));
} else {
    echo json_encode(array(
        "success" => false,
    ));
}

$stmt->close();
$connect->close();
