<?php
// get_webhook_url.php
// Ambil URL webhook dari tabel webhook_urls berdasarkan name + environment
// Response: { success: true/false, url: "...", message: "..." }

header('Content-Type: application/json; charset=utf-8');

// Koneksi
require_once '../connection.php'; // pastikan $connect = new mysqli(...)

function respond($success, $data = []) {
    echo json_encode(array_merge(["success" => $success], $data));
    exit;
}

// Ambil input (pakai POST seperti referensi kamu)
$name = isset($_POST['name']) ? trim($_POST['name']) : 'order_notify';
$environment = isset($_POST['environment']) ? trim($_POST['environment']) : 'prod';

// Validasi sederhana
$allowedEnv = ['test', 'prod'];
if (!in_array($environment, $allowedEnv, true)) {
    respond(false, ["message" => "environment harus 'test' atau 'prod'"]);
}

// Query pakai prepared statement
$sql = "SELECT url 
        FROM webhook_urls 
        WHERE name = ? AND environment = ? AND status = 'active'
        LIMIT 1";

$stmt = $connect->prepare($sql);
if (!$stmt) {
    respond(false, ["message" => "Gagal prepare statement"]);
}

$stmt->bind_param("ss", $name, $environment);
$stmt->execute();
$stmt->bind_result($url);

if ($stmt->fetch() && !empty($url)) {
    respond(true, ["url" => $url]);
} else {
    respond(false, ["message" => "URL tidak ditemukan untuk name=$name environment=$environment"]);
}

$stmt->close();
$connect->close();
